<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Events\V1\Subscription;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class SubscribedEventOptions {
    /**
     * @param int $version The schema version that the subscription should use.
     * @return CreateSubscribedEventOptions Options builder
     */
    public static function create(int $version = Values::NONE): CreateSubscribedEventOptions {
        return new CreateSubscribedEventOptions($version);
    }

    /**
     * @param int $version The schema version that the subscription should use.
     * @return UpdateSubscribedEventOptions Options builder
     */
    public static function update(int $version = Values::NONE): UpdateSubscribedEventOptions {
        return new UpdateSubscribedEventOptions($version);
    }
}

class CreateSubscribedEventOptions extends Options {
    /**
     * @param int $version The schema version that the subscription should use.
     */
    public function __construct(int $version = Values::NONE) {
        $this->options['version'] = $version;
    }

    /**
     * The schema version that the subscription should use.
     *
     * @param int $version The schema version that the subscription should use.
     * @return $this Fluent Builder
     */
    public function setVersion(int $version): self {
        $this->options['version'] = $version;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Events.V1.CreateSubscribedEventOptions ' . $options . ']';
    }
}

class UpdateSubscribedEventOptions extends Options {
    /**
     * @param int $version The schema version that the subscription should use.
     */
    public function __construct(int $version = Values::NONE) {
        $this->options['version'] = $version;
    }

    /**
     * The schema version that the subscription should use.
     *
     * @param int $version The schema version that the subscription should use.
     * @return $this Fluent Builder
     */
    public function setVersion(int $version): self {
        $this->options['version'] = $version;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Events.V1.UpdateSubscribedEventOptions ' . $options . ']';
    }
}